/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.PartitionedPrefix;
import software.amazon.awssdk.services.s3.model.SimplePrefix;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetObjectKeyFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetObjectKeyFormat> {
    private static final SdkField<SimplePrefix> SIMPLE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SimplePrefix").getter(TargetObjectKeyFormat.getter(TargetObjectKeyFormat::simplePrefix)).setter(TargetObjectKeyFormat.setter(Builder::simplePrefix)).constructor(SimplePrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimplePrefix").unmarshallLocationName("SimplePrefix").build()}).build();
    private static final SdkField<PartitionedPrefix> PARTITIONED_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartitionedPrefix").getter(TargetObjectKeyFormat.getter(TargetObjectKeyFormat::partitionedPrefix)).setter(TargetObjectKeyFormat.setter(Builder::partitionedPrefix)).constructor(PartitionedPrefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionedPrefix").unmarshallLocationName("PartitionedPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_PREFIX_FIELD, PARTITIONED_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetObjectKeyFormat.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SimplePrefix simplePrefix;
    private final PartitionedPrefix partitionedPrefix;

    private TargetObjectKeyFormat(BuilderImpl builder) {
        this.simplePrefix = builder.simplePrefix;
        this.partitionedPrefix = builder.partitionedPrefix;
    }

    public final SimplePrefix simplePrefix() {
        return this.simplePrefix;
    }

    public final PartitionedPrefix partitionedPrefix() {
        return this.partitionedPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.simplePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionedPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetObjectKeyFormat)) {
            return false;
        }
        TargetObjectKeyFormat other = (TargetObjectKeyFormat)obj;
        return Objects.equals(this.simplePrefix(), other.simplePrefix()) && Objects.equals(this.partitionedPrefix(), other.partitionedPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"TargetObjectKeyFormat").add("SimplePrefix", (Object)this.simplePrefix()).add("PartitionedPrefix", (Object)this.partitionedPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SimplePrefix": {
                return Optional.ofNullable(clazz.cast(this.simplePrefix()));
            }
            case "PartitionedPrefix": {
                return Optional.ofNullable(clazz.cast(this.partitionedPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SimplePrefix", SIMPLE_PREFIX_FIELD);
        map.put("PartitionedPrefix", PARTITIONED_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetObjectKeyFormat, T> g) {
        return obj -> g.apply((TargetObjectKeyFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SimplePrefix simplePrefix;
        private PartitionedPrefix partitionedPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetObjectKeyFormat model) {
            this.simplePrefix(model.simplePrefix);
            this.partitionedPrefix(model.partitionedPrefix);
        }

        public final SimplePrefix.Builder getSimplePrefix() {
            return this.simplePrefix != null ? this.simplePrefix.toBuilder() : null;
        }

        public final void setSimplePrefix(SimplePrefix.BuilderImpl simplePrefix) {
            this.simplePrefix = simplePrefix != null ? simplePrefix.build() : null;
        }

        @Override
        public final Builder simplePrefix(SimplePrefix simplePrefix) {
            this.simplePrefix = simplePrefix;
            return this;
        }

        public final PartitionedPrefix.Builder getPartitionedPrefix() {
            return this.partitionedPrefix != null ? this.partitionedPrefix.toBuilder() : null;
        }

        public final void setPartitionedPrefix(PartitionedPrefix.BuilderImpl partitionedPrefix) {
            this.partitionedPrefix = partitionedPrefix != null ? partitionedPrefix.build() : null;
        }

        @Override
        public final Builder partitionedPrefix(PartitionedPrefix partitionedPrefix) {
            this.partitionedPrefix = partitionedPrefix;
            return this;
        }

        public TargetObjectKeyFormat build() {
            return new TargetObjectKeyFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetObjectKeyFormat> {
        public Builder simplePrefix(SimplePrefix var1);

        default public Builder simplePrefix(Consumer<SimplePrefix.Builder> simplePrefix) {
            return this.simplePrefix((SimplePrefix)((SimplePrefix.Builder)SimplePrefix.builder().applyMutation(simplePrefix)).build());
        }

        public Builder partitionedPrefix(PartitionedPrefix var1);

        default public Builder partitionedPrefix(Consumer<PartitionedPrefix.Builder> partitionedPrefix) {
            return this.partitionedPrefix((PartitionedPrefix)((PartitionedPrefix.Builder)PartitionedPrefix.builder().applyMutation(partitionedPrefix)).build());
        }
    }
}

