/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservationTenancy;
import software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria;
import software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecification;
import software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapacityReservationFleetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateCapacityReservationFleetRequest> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::allocationStrategy)).setter(CreateCapacityReservationFleetRequest.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("AllocationStrategy").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::clientToken)).setter(CreateCapacityReservationFleetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<ReservationFleetInstanceSpecification>> INSTANCE_TYPE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypeSpecifications").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::instanceTypeSpecifications)).setter(CreateCapacityReservationFleetRequest.setter(Builder::instanceTypeSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeSpecification").unmarshallLocationName("InstanceTypeSpecification").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservationFleetInstanceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::tenancyAsString)).setter(CreateCapacityReservationFleetRequest.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("Tenancy").build()}).build();
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalTargetCapacity").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::totalTargetCapacity)).setter(CreateCapacityReservationFleetRequest.setter(Builder::totalTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity").unmarshallLocationName("TotalTargetCapacity").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::endDate)).setter(CreateCapacityReservationFleetRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("EndDate").build()}).build();
    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMatchCriteria").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::instanceMatchCriteriaAsString)).setter(CreateCapacityReservationFleetRequest.setter(Builder::instanceMatchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria").unmarshallLocationName("InstanceMatchCriteria").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::tagSpecifications)).setter(CreateCapacityReservationFleetRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateCapacityReservationFleetRequest.getter(CreateCapacityReservationFleetRequest::dryRun)).setter(CreateCapacityReservationFleetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, CLIENT_TOKEN_FIELD, INSTANCE_TYPE_SPECIFICATIONS_FIELD, TENANCY_FIELD, TOTAL_TARGET_CAPACITY_FIELD, END_DATE_FIELD, INSTANCE_MATCH_CRITERIA_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCapacityReservationFleetRequest.memberNameToFieldInitializer();
    private final String allocationStrategy;
    private final String clientToken;
    private final List<ReservationFleetInstanceSpecification> instanceTypeSpecifications;
    private final String tenancy;
    private final Integer totalTargetCapacity;
    private final Instant endDate;
    private final String instanceMatchCriteria;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;

    private CreateCapacityReservationFleetRequest(BuilderImpl builder) {
        super(builder);
        this.allocationStrategy = builder.allocationStrategy;
        this.clientToken = builder.clientToken;
        this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
        this.tenancy = builder.tenancy;
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.endDate = builder.endDate;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
    }

    public final String allocationStrategy() {
        return this.allocationStrategy;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasInstanceTypeSpecifications() {
        return this.instanceTypeSpecifications != null && !(this.instanceTypeSpecifications instanceof SdkAutoConstructList);
    }

    public final List<ReservationFleetInstanceSpecification> instanceTypeSpecifications() {
        return this.instanceTypeSpecifications;
    }

    public final FleetCapacityReservationTenancy tenancy() {
        return FleetCapacityReservationTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final Integer totalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final FleetInstanceMatchCriteria instanceMatchCriteria() {
        return FleetInstanceMatchCriteria.fromValue(this.instanceMatchCriteria);
    }

    public final String instanceMatchCriteriaAsString() {
        return this.instanceMatchCriteria;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypeSpecifications() ? this.instanceTypeSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationFleetRequest)) {
            return false;
        }
        CreateCapacityReservationFleetRequest other = (CreateCapacityReservationFleetRequest)((Object)obj);
        return Objects.equals(this.allocationStrategy(), other.allocationStrategy()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasInstanceTypeSpecifications() == other.hasInstanceTypeSpecifications() && Objects.equals(this.instanceTypeSpecifications(), other.instanceTypeSpecifications()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.totalTargetCapacity(), other.totalTargetCapacity()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapacityReservationFleetRequest").add("AllocationStrategy", (Object)this.allocationStrategy()).add("ClientToken", (Object)this.clientToken()).add("InstanceTypeSpecifications", this.hasInstanceTypeSpecifications() ? this.instanceTypeSpecifications() : null).add("Tenancy", (Object)this.tenancyAsString()).add("TotalTargetCapacity", (Object)this.totalTargetCapacity()).add("EndDate", (Object)this.endDate()).add("InstanceMatchCriteria", (Object)this.instanceMatchCriteriaAsString()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategy()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceTypeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeSpecifications()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "TotalTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalTargetCapacity()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "InstanceMatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.instanceMatchCriteriaAsString()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllocationStrategy", ALLOCATION_STRATEGY_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceTypeSpecification", INSTANCE_TYPE_SPECIFICATIONS_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("TotalTargetCapacity", TOTAL_TARGET_CAPACITY_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("InstanceMatchCriteria", INSTANCE_MATCH_CRITERIA_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationFleetRequest, T> g) {
        return obj -> g.apply((CreateCapacityReservationFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String clientToken;
        private List<ReservationFleetInstanceSpecification> instanceTypeSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String tenancy;
        private Integer totalTargetCapacity;
        private Instant endDate;
        private String instanceMatchCriteria;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationFleetRequest model) {
            super(model);
            this.allocationStrategy(model.allocationStrategy);
            this.clientToken(model.clientToken);
            this.instanceTypeSpecifications(model.instanceTypeSpecifications);
            this.tenancy(model.tenancy);
            this.totalTargetCapacity(model.totalTargetCapacity);
            this.endDate(model.endDate);
            this.instanceMatchCriteria(model.instanceMatchCriteria);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<ReservationFleetInstanceSpecification.Builder> getInstanceTypeSpecifications() {
            List<ReservationFleetInstanceSpecification.Builder> result = ReservationFleetInstanceSpecificationListCopier.copyToBuilder(this.instanceTypeSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypeSpecifications(Collection<ReservationFleetInstanceSpecification.BuilderImpl> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = ReservationFleetInstanceSpecificationListCopier.copyFromBuilder(instanceTypeSpecifications);
        }

        @Override
        public final Builder instanceTypeSpecifications(Collection<ReservationFleetInstanceSpecification> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = ReservationFleetInstanceSpecificationListCopier.copy(instanceTypeSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(ReservationFleetInstanceSpecification ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Arrays.asList(instanceTypeSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(Consumer<ReservationFleetInstanceSpecification.Builder> ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Stream.of(instanceTypeSpecifications).map(c -> (ReservationFleetInstanceSpecification)((ReservationFleetInstanceSpecification.Builder)ReservationFleetInstanceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(FleetCapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Integer getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(FleetInstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityReservationFleetRequest build() {
            return new CreateCapacityReservationFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapacityReservationFleetRequest> {
        public Builder allocationStrategy(String var1);

        public Builder clientToken(String var1);

        public Builder instanceTypeSpecifications(Collection<ReservationFleetInstanceSpecification> var1);

        public Builder instanceTypeSpecifications(ReservationFleetInstanceSpecification ... var1);

        public Builder instanceTypeSpecifications(Consumer<ReservationFleetInstanceSpecification.Builder> ... var1);

        public Builder tenancy(String var1);

        public Builder tenancy(FleetCapacityReservationTenancy var1);

        public Builder totalTargetCapacity(Integer var1);

        public Builder endDate(Instant var1);

        public Builder instanceMatchCriteria(String var1);

        public Builder instanceMatchCriteria(FleetInstanceMatchCriteria var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

