"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    rollupService,
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.ROLLUPS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.getRollups);
  router.put({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, rollupService.putRollup);
  router.get({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.getRollup);
  router.delete({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.deleteRollup);
  router.post({
    path: `${_constants.NODE_API.ROLLUPS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.startRollup);
  router.post({
    path: `${_constants.NODE_API.ROLLUPS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.stopRollup);
  router.post({
    path: _constants.NODE_API._MAPPINGS,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, rollupService.getMappings);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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