/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;

public class RACInstanceImpl
implements RACInstance {
    private final String service;
    private final String instance;
    private final String host;
    private final String database;
    private float percent = 0.0f;
    private OracleLoadBalancingEvent.InstanceStatus status = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
    private boolean affinityHint = false;

    public RACInstanceImpl(String service, String instance, String host, String database) {
        this.service = service;
        this.instance = instance;
        this.host = host;
        this.database = database;
    }

    public RACInstanceImpl(OracleDatabaseInstanceInfo dbinfo) {
        this.service = dbinfo.getServiceName();
        this.instance = dbinfo.getInstanceName();
        this.host = dbinfo.getHostName();
        this.database = dbinfo.getDatabaseName();
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public int getPercent() {
        return Math.round(this.percent);
    }

    @Override
    public float getFloatPercent() {
        return this.percent;
    }

    @Override
    public OracleLoadBalancingEvent.InstanceStatus getInstanceStatus() {
        return this.status;
    }

    public void setPercent(int rlbPercent) {
        this.percent = rlbPercent;
    }

    public void setFloatPercent(float rlbPercent) {
        this.percent = rlbPercent;
    }

    public void setStatus(OracleLoadBalancingEvent.InstanceStatus rlbStatus) {
        this.status = rlbStatus;
    }

    boolean getAffinityHint() {
        return this.affinityHint;
    }

    public void setAffinityHint(boolean affHint) {
        this.affinityHint = affHint;
    }

    public String toString() {
        return "Service name: " + this.service + ", Instance name: " + this.instance + ", Host name: " + this.host + ", Database unique name: " + this.database;
    }
}

