/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BasicPainter
implements SwingConstants,
ThemePainter {
    private static BasicPainter _instance;
    protected Color _bk0;
    protected Color _bk1;
    protected Color _bk2;
    protected Color _bk3;
    protected Color _borderColor;
    public static int V_GAP;
    public static int H_GAP;
    public static int ARROW_TEXT_GAP;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new BasicPainter();
        }
        return _instance;
    }

    public void installDefaults() {
        if (this._bk0 == null) {
            this._bk0 = UIDefaultsLookup.getColor("JideButton.background");
        }
        if (this._bk1 == null) {
            this._bk1 = UIDefaultsLookup.getColor("JideButton.focusedBackground");
        }
        if (this._bk2 == null) {
            this._bk2 = UIDefaultsLookup.getColor("JideButton.selectedBackground");
        }
        if (this._bk3 == null) {
            this._bk3 = UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground");
        }
        if (this._borderColor == null) {
            this._borderColor = UIDefaultsLookup.getColor("JideButton.borderColor");
        }
    }

    public void uninstallDefaults() {
        this._borderColor = null;
        this._bk0 = null;
        this._bk1 = null;
        this._bk2 = null;
        this._bk3 = null;
    }

    @Override
    public Color getGripperForeground() {
        return UIDefaultsLookup.getColor("Gripper.foreground");
    }

    @Override
    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    @Override
    public Color getSeparatorForeground() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    @Override
    public Color getSeparatorForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    @Override
    public Color getCollapsiblePaneContentBackground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.contentBackground");
    }

    @Override
    public Color getCollapsiblePaneTitleForeground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.foreground");
    }

    @Override
    public Color getCollapsiblePaneTitleForegroundEmphasized() {
        return UIDefaultsLookup.getColor("CollapsiblePane.emphasizedForeground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForegroundEmphasized() {
        return UIDefaultsLookup.getColor("CollapsiblePane.emphasizedForeground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForeground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.foreground");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIcon() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.upIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIcon() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.downIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIconEmphasized() {
        return this.getCollapsiblePaneUpIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIconEmphasized() {
        return this.getCollapsiblePaneDownIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackground() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.titleButtonBackground");
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackgroundEmphasized() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.titleButtonBackground.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpMask() {
        return this.getCollapsiblePaneUpIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneDownMask() {
        return this.getCollapsiblePaneDownIcon();
    }

    @Override
    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getSelectionSelectedDk() {
        return this._bk2;
    }

    @Override
    public Color getSelectionSelectedLt() {
        return this._bk2;
    }

    @Override
    public Color getMenuItemBorderColor() {
        return UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
    }

    @Override
    public Color getMenuItemBackground() {
        return UIDefaultsLookup.getColor("MenuItem.background");
    }

    @Override
    public Color getCommandBarTitleBarBackground() {
        return UIDefaultsLookup.getColor("CommandBar.titleBarBackground");
    }

    @Override
    public Color getControl() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getControlLt() {
        return this.getControlShadow();
    }

    @Override
    public Color getControlDk() {
        return this.getControlShadow();
    }

    @Override
    public Color getControlShadow() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    @Override
    public Color getTitleBarBackground() {
        return UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
    }

    @Override
    public Color getDockableFrameTitleBarActiveForeground() {
        return UIDefaultsLookup.getColor("DockableFrame.activeTitleForeground");
    }

    @Override
    public Color getDockableFrameTitleBarInactiveForeground() {
        return UIDefaultsLookup.getColor("DockableFrame.inactiveTitleForeground");
    }

    @Override
    public Color getTabbedPaneSelectDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackgroundDk");
    }

    @Override
    public Color getTabbedPaneSelectLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackgroundlt");
    }

    @Override
    public Color getTabAreaBackgroundDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackgroundDk");
    }

    @Override
    public Color getTabAreaBackgroundLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackgroundLt");
    }

    @Override
    public Color getOptionPaneBannerForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    @Override
    public Color getOptionPaneBannerDk() {
        return new ColorUIResource(45, 96, 249);
    }

    @Override
    public Color getOptionPaneBannerLt() {
        return new ColorUIResource(0, 52, 206);
    }

    @Override
    public void paintSelectedMenu(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        Color oldColor = g2.getColor();
        g2.setColor(UIDefaultsLookup.getColor("JideButton.darkShadow"));
        g2.drawLine(rect.x, rect.y + rect.height, rect.x, rect.y + 1);
        g2.drawLine(rect.x + rect.width - 2, rect.y, rect.x + rect.width - 2, rect.y + rect.height);
        if (orientation == 0) {
            g2.drawLine(rect.x, rect.y, rect.x + rect.width - 3, rect.y);
        } else {
            g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 3, rect.y + rect.height - 1);
        }
        g2.setColor(oldColor);
    }

    @Override
    public void paintMenuItemBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        this.paintMenuItemBackground(c, g2, rect, orientation, state, true);
    }

    @Override
    public void paintMenuItemBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state, boolean showBorder) {
        this.paintButtonBackground(c, g2, rect, orientation, state, showBorder);
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        this.paintButtonBackground(c, g2, rect, orientation, state, true);
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state, boolean showBorder) {
        this.installDefaults();
        Color background = null;
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            background = c.getBackground();
            this.paintBackground(c, g2, rect, state == 0 || state == 4 ? null : this._borderColor, state == 1 || state == 3 || state == 2 ? UIDefaultsLookup.getColor("JideButton.selectedBackground") : background, orientation);
            return;
        }
        switch (state) {
            case 0: {
                background = c.getBackground();
                if (background == null || background instanceof UIResource) {
                    background = this._bk0;
                }
                this.paintBackground(c, g2, rect, showBorder ? this._borderColor : null, background, orientation);
                break;
            }
            case 2: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(2);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk1;
                }
                this.paintBackground(c, g2, rect, showBorder ? this._borderColor : null, background, orientation);
                break;
            }
            case 3: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(3);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk2;
                }
                this.paintBackground(c, g2, rect, showBorder ? this._borderColor : null, background, orientation);
                break;
            }
            case 5: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(3);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk2;
                }
                this.paintBackground(c, g2, rect, showBorder ? ColorUtils.toGrayscale(this._borderColor) : null, ColorUtils.toGrayscale(background), orientation);
                break;
            }
            case 1: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(1);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk3;
                }
                this.paintBackground(c, g2, rect, showBorder ? this._borderColor : null, background, orientation);
            }
        }
    }

    protected void paintBackground(JComponent c, Graphics g2, Rectangle rect, Color borderColor, Color background, int orientation) {
        Color oldColor = g2.getColor();
        if (borderColor != null) {
            boolean paintDefaultBorder = true;
            Object o = c.getClientProperty("JideButton.paintDefaultBorder");
            if (o instanceof Boolean) {
                paintDefaultBorder = (Boolean)o;
            }
            if (paintDefaultBorder) {
                g2.setColor(borderColor);
                Object position = c.getClientProperty("JButton.segmentPosition");
                if (position == null || "only".equals(position)) {
                    g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                } else if ("first".equals(position)) {
                    if (orientation == 0) {
                        g2.drawRect(rect.x, rect.y, rect.width, rect.height - 1);
                    } else {
                        g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height);
                    }
                } else if ("middle".equals(position)) {
                    if (orientation == 0) {
                        g2.drawRect(rect.x, rect.y, rect.width, rect.height - 1);
                    } else {
                        g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height);
                    }
                } else if ("last".equals(position)) {
                    if (orientation == 0) {
                        g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    } else {
                        g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    }
                }
            }
            g2.setColor(background);
            g2.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        } else {
            g2.setColor(background);
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        g2.setColor(oldColor);
    }

    @Override
    public void paintChevronBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (state != 0) {
            this.paintButtonBackground(c, g2, rect, orientation, state);
        }
    }

    @Override
    public void paintDividerBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        Color oldColor = g2.getColor();
        g2.setColor(UIDefaultsLookup.getColor("SplitPane.background"));
        g2.fillRect(0, 0, rect.width, rect.height);
        g2.setColor(oldColor);
    }

    @Override
    public void paintCommandBarBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(UIDefaultsLookup.getColor("CommandBar.background"));
        g2.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 2, 2);
    }

    @Override
    public void paintFloatingCommandBarBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(UIDefaultsLookup.getColor("CommandBar.background"));
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintMenuShadow(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        Color oldColor = g2.getColor();
        g2.setColor(UIDefaultsLookup.getColor("MenuItem.shadowColor"));
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(oldColor);
    }

    @Override
    public void paintContentBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(UIDefaultsLookup.getColor("control"));
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintStatusBarBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (c.isOpaque()) {
            this.paintContentBackground(c, g2, rect, orientation, state);
        }
    }

    @Override
    public void paintCommandBarTitlePane(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(this.getCommandBarTitleBarBackground());
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintGripper(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(this.getGripperForeground());
        if (rect.width > rect.height) {
            rect.x = rect.x + rect.width / 2 - 10;
            rect.width = 22;
        } else {
            rect.y = rect.y + rect.height / 2 - 10;
            rect.height = 22;
        }
        if (orientation == 0) {
            if (rect.width <= 30) {
                int MARGIN = 3;
                for (int i = 0; i < (rect.height - 6) / 2; ++i) {
                    g2.drawLine(rect.x + 3, rect.y + 3 + i * 2, rect.x + rect.width - 3, rect.y + 3 + i * 2);
                }
            } else {
                int MARGIN = 2;
                for (int i = 0; i < (rect.height - 4) / 2; ++i) {
                    g2.drawLine((rect.width - rect.width) / 2, rect.y + 2 + i * 2, (rect.width + rect.width) / 2, rect.y + 2 + i * 2);
                }
            }
        } else {
            int MARGIN = 3;
            int count = (rect.width - 6) / 2;
            for (int i = 0; i < count; ++i) {
                int x = rect.x + rect.width / 2 - count + i * 2;
                g2.drawLine(x, rect.y + 3, x, rect.y + rect.height - 3);
            }
        }
    }

    @Override
    public void paintChevronMore(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        block6: {
            block5: {
                g2.setColor(UIDefaultsLookup.getColor("CommandBar.darkShadow"));
                if (orientation != 0) break block5;
                if (!c.getComponentOrientation().isLeftToRight()) {
                    int y = rect.y + 4;
                    for (int i = -2; i <= 2; ++i) {
                        int offset = Math.abs(i);
                        g2.drawLine(rect.x + 2 + offset, y, rect.x + 3 + offset, y);
                        g2.drawLine(rect.x + 6 + offset, y, rect.x + 7 + offset, y);
                        ++y;
                    }
                } else {
                    int y = rect.y + 4;
                    for (int i = -2; i <= 2; ++i) {
                        int offset = -Math.abs(i);
                        g2.drawLine(rect.x + 4 + offset, y, rect.x + 5 + offset, y);
                        g2.drawLine(rect.x + 8 + offset, y, rect.x + 9 + offset, y);
                        ++y;
                    }
                }
                break block6;
            }
            if (orientation != 1) break block6;
            int x = rect.x + 4;
            for (int i = -2; i <= 2; ++i) {
                int offset = -Math.abs(i);
                g2.drawLine(x, rect.y + 4 + offset, x, rect.y + 5 + offset);
                g2.drawLine(x, rect.y + 8 + offset, x, rect.y + 9 + offset);
                ++x;
            }
        }
    }

    @Override
    public void paintChevronOption(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int startY;
        int startX;
        if (orientation == 0 || !c.getComponentOrientation().isLeftToRight()) {
            startX = rect.x + 3;
            startY = rect.y + rect.height - 7;
        } else {
            startX = rect.x + rect.width - 7;
            startY = rect.y + 3;
        }
        if (orientation == 0 || !c.getComponentOrientation().isLeftToRight()) {
            JideSwingUtilities.paintArrow(g2, UIDefaultsLookup.getColor("CommandBar.darkShadow"), startX, startY, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(g2, UIDefaultsLookup.getColor("CommandBar.darkShadow"), startX, startY, 5, orientation);
        }
    }

    @Override
    public void paintFloatingChevronOption(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int startX = rect.width / 2 - 4;
        int startY = rect.height / 2 - 2;
        if (state == 2) {
            JideSwingUtilities.paintArrow(g2, Color.BLACK, startX, startY, 9, orientation);
        } else {
            JideSwingUtilities.paintArrow(g2, Color.WHITE, startX, startY, 9, orientation);
        }
    }

    @Override
    public void paintDockableFrameBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!c.isOpaque()) {
            return;
        }
        g2.setColor(UIDefaultsLookup.getColor("DockableFrame.background"));
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width - 1;
        int h2 = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h2 -= insets.top + insets.bottom;
        }
        rect = new Rectangle(x + 1, y + 1, w - 1, h2 - 1);
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (state == 3) {
            g2.setColor(UIDefaultsLookup.getColor("DockableFrame.activeTitleBorderColor"));
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                g2.drawRoundRect(x, y, w, h2, 2, 2);
            } else {
                g2.drawRect(x, y, w, h2);
            }
            g2.setColor(highContrast != false ? UIDefaultsLookup.getColor("JideButton.selectedBackground") : UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground"));
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            g2.setColor(UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBorderColor"));
            g2.drawRoundRect(x, y, w, h2, 2, 2);
            g2.setColor(UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBackground"));
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            JideSwingUtilities.fillGradient(g2, rect, 0);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (!(c.getBackground() instanceof UIResource)) {
            g2.setColor(c.getBackground());
        } else {
            g2.setColor(UIDefaultsLookup.getColor(highContrast != false ? "JideButton.background" : "CollapsiblePane.background"));
        }
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        if (highContrast.booleanValue()) {
            g2.setColor(UIDefaultsLookup.getColor("CollapsiblePane.background"));
            g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!(c.getBackground() instanceof UIResource)) {
            g2.setColor(c.getBackground());
        } else {
            g2.setColor(UIDefaultsLookup.getColor("CollapsiblePane.emphasizedBackground"));
        }
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintCollapsiblePanesBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!c.isOpaque()) {
            return;
        }
        if (!(c.getBackground() instanceof UIResource)) {
            g2.setColor(c.getBackground());
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            g2.setColor(UIDefaultsLookup.getColor("TextField.background"));
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlainEmphasized(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(UIDefaultsLookup.getColor("CollapsiblePane.emphasizedBackground"));
        g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlain(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (!(c.getBackground() instanceof UIResource)) {
            g2.setColor(c.getBackground());
        } else {
            g2.setColor(UIDefaultsLookup.getColor("CollapsiblePane.background"));
        }
        switch (orientation) {
            case 3: {
                g2.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                break;
            }
            case 7: {
                g2.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                break;
            }
            case 1: {
                g2.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            }
            default: {
                g2.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
            }
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(UIManager.getColor("CollapsiblePane.emphasizedBackground"));
        g2.fillRect(rect.x, rect.y, rect.x + rect.width, rect.height);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        g2.setColor(UIManager.getColor("CollapsiblePane.background"));
        g2.fillRect(rect.x, rect.y, rect.x + rect.width, rect.height);
    }

    @Override
    public Color getColor(Object key) {
        return UIDefaultsLookup.getColor(key);
    }

    @Override
    public void paintTabAreaBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (c.isOpaque() && c instanceof JideTabbedPane) {
            JideTabbedPane tabbedPane = (JideTabbedPane)c;
            int tabShape = tabbedPane.getTabShape();
            int colorTheme = tabbedPane.getColorTheme();
            if (tabShape == 3) {
                g2.setColor(UIDefaultsLookup.getColor("control"));
            } else if (colorTheme == 1) {
                g2.setColor(UIDefaultsLookup.getColor("control"));
            } else if (colorTheme == 3) {
                g2.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
            } else {
                g2.setColor(UIDefaultsLookup.getColor("control"));
            }
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void paintTabBackground(JComponent c, Graphics g2, Shape region, Color[] colors, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g2.create();
        Color backgroundStart = colors[0];
        Color backgroundEnd = colors[1];
        if (backgroundEnd != null && backgroundStart != null) {
            int tabPlacement = 1;
            if (c instanceof JideTabbedPane) {
                tabPlacement = ((JideTabbedPane)c).getTabPlacement();
            }
            switch (tabPlacement) {
                case 2: {
                    JideSwingUtilities.fillGradient(g2d, region, backgroundStart, backgroundEnd, false);
                    break;
                }
                case 4: {
                    JideSwingUtilities.fillGradient(g2d, region, backgroundEnd, backgroundStart, false);
                    break;
                }
                case 3: {
                    JideSwingUtilities.fillGradient(g2d, region, backgroundEnd, backgroundStart, true);
                    break;
                }
                default: {
                    JideSwingUtilities.fillGradient(g2d, region, backgroundStart, backgroundEnd, true);
                }
            }
        }
        g2d.dispose();
    }

    @Override
    public void paintTabContentBorder(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
    }

    @Override
    public void paintSidePaneItemBackground(JComponent c, Graphics g2, Rectangle rect, Color[] colors, int orientation, int state) {
        Color startColor = colors != null && colors.length > 0 ? colors[0] : c.getBackground();
        Color endColor = colors != null && colors.length > 1 ? colors[1] : startColor;
        switch (orientation) {
            case 7: {
                JideSwingUtilities.fillGradient((Graphics2D)g2, rect, startColor, endColor, false);
                break;
            }
            case 3: {
                JideSwingUtilities.fillGradient((Graphics2D)g2, rect, endColor, startColor, false);
                break;
            }
            case 1: {
                JideSwingUtilities.fillGradient((Graphics2D)g2, rect, startColor, endColor, true);
                break;
            }
            case 5: {
                JideSwingUtilities.fillGradient((Graphics2D)g2, rect, endColor, startColor, true);
            }
        }
    }

    @Override
    public void paintHeaderBoxBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        boolean isCellEditor = Boolean.TRUE.equals(c.getClientProperty("HeaderBox.isTableCellEditor"));
        Color baseColor = c.getBackground();
        if (baseColor instanceof UIResource && (baseColor = UIDefaultsLookup.getColor("HeaderBox.background")) == null) {
            baseColor = UIDefaultsLookup.getColor("control");
        }
        if (state == 1 || state == 3 || state == 2) {
            Color color = ColorUtils.getDerivedColor(baseColor, 0.48f);
            if (isCellEditor) {
                g2.setColor(color);
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            } else {
                g2.setColor(color);
                g2.fillRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 4, 4);
                g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.4f));
                g2.drawRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 6, 6);
            }
            g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.45f));
            g2.drawLine(rect.x + 1, rect.y + rect.height - 3, rect.x + rect.width - 2, rect.y + rect.height - 3);
            g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.43f));
            g2.drawLine(rect.x + 2, rect.y + rect.height - 2, rect.x + rect.width - 3, rect.y + rect.height - 2);
            g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.4f));
            g2.drawLine(rect.x + 3, rect.y + rect.height - 1, rect.x + rect.width - 4, rect.y + rect.height - 1);
        } else {
            if (isCellEditor) {
                g2.setColor(baseColor);
                g2.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            } else {
                g2.setColor(baseColor);
                g2.fillRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 2, 2);
                g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.42f));
                g2.drawRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 2, 4);
            }
            g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.48f));
            g2.drawLine(rect.x + 1, rect.y + rect.height - 3, rect.x + rect.width - 2, rect.y + rect.height - 3);
            g2.setColor(ColorUtils.getDerivedColor(baseColor, 0.47f));
            g2.drawLine(rect.x + 1, rect.y + rect.height - 2, rect.x + rect.width - 2, rect.y + rect.height - 2);
            if (isCellEditor) {
                g2.setColor(new Color(198, 197, 178));
                g2.drawLine(rect.x + rect.width - 3, rect.y + 4, rect.x + rect.width - 3, rect.y + rect.height - 7);
                g2.setColor(Color.WHITE);
                g2.drawLine(rect.x + rect.width - 2, rect.y + 4, rect.x + rect.width - 2, rect.y + rect.height - 7);
            }
        }
    }

    @Override
    public void paintToolBarSeparator(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (c.isOpaque()) {
            g2.setColor(c.getBackground());
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (orientation == 0) {
            g2.setColor(c.getForeground());
            g2.drawLine(rect.x + rect.width / 2, rect.y + 1, rect.x + rect.width / 2, rect.y + rect.height - 2);
        } else {
            g2.setColor(c.getForeground());
            g2.drawLine(rect.x + 1, rect.y + rect.height / 2, rect.x + rect.width - 2, rect.y + rect.height / 2);
        }
    }

    @Override
    public void paintPopupMenuSeparator(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        int defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        int defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
        Color shadowColor = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        Color foreground = UIDefaultsLookup.getColor("PopupMenuSeparator.foreground");
        Color background = UIDefaultsLookup.getColor("PopupMenuSeparator.background");
        g2.setColor(shadowColor);
        if (c.getComponentOrientation().isLeftToRight()) {
            g2.fillRect(0, 0, defaultShadowWidth, rect.height);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillSingleGradient(g2, new Rectangle(rect.x, rect.y, defaultShadowWidth, rect.height), 3, 255);
            }
            g2.setColor(background);
            g2.fillRect(rect.x + defaultShadowWidth, rect.y, rect.width - defaultShadowWidth, rect.height);
            g2.setColor(foreground);
            g2.drawLine(rect.x + defaultShadowWidth + defaultTextIconGap, rect.y + 1, rect.x + rect.width, rect.y + 1);
        } else {
            g2.fillRect(rect.x + rect.width, rect.y, defaultShadowWidth, rect.height);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillSingleGradient(g2, new Rectangle(rect.x + rect.width - defaultTextIconGap, rect.y, defaultShadowWidth, 2), 7, 255);
            }
            g2.setColor(background);
            g2.fillRect(rect.x, rect.y, rect.width - defaultShadowWidth, rect.height);
            g2.setColor(foreground);
            g2.drawLine(rect.x, rect.y + 1, rect.x + rect.width - defaultShadowWidth - defaultTextIconGap, rect.y + 1);
        }
    }

    @Override
    public void paintStatusBarSeparator(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
    }

    protected boolean shouldDisplayOnTop() {
        return SystemInfo.isWindowsVistaAbove() && LookAndFeelFactory.isWindowsLookAndFeel(UIManager.getLookAndFeel()) && !LookAndFeelFactory.isWindowsClassicLookAndFeel(UIManager.getLookAndFeel()) && XPUtils.isXPStyleOn();
    }

    @Override
    public void fillBackground(JComponent c, Graphics g2, Rectangle rect, int orientation, int state, Color color) {
        Color oldColor = g2.getColor();
        g2.setColor(color);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(oldColor);
    }

    @Override
    public Insets getSortableTableHeaderColumnCellDecoratorInsets(JComponent c, Graphics g2, Rectangle rect, int orientation, int state, int sortOrder, Icon sortIcon, int orderIndex, Color indexColor, boolean paintIndex) {
        if (this.shouldDisplayOnTop()) {
            return null;
        }
        int iconWidth = sortIcon == null ? 0 : sortIcon.getIconWidth();
        int textWidthAndGap = 0;
        if (paintIndex && orderIndex != -1) {
            Font font;
            if (g2 != null) {
                Font oldFont = g2.getFont();
                font = g2.getFont().deriveFont(0, oldFont.getSize() - 3);
            } else {
                font = c.getFont() != null ? c.getFont().deriveFont(0, c.getFont().getSize() - 3) : Font.getFont("Arial");
            }
            String str = "" + (orderIndex + 1);
            int textWidth = SwingUtilities.computeStringWidth(c.getFontMetrics(font), str);
            textWidthAndGap = ARROW_TEXT_GAP + textWidth + H_GAP;
        } else {
            textWidthAndGap = H_GAP;
        }
        if (textWidthAndGap + iconWidth == 0) {
            return null;
        }
        return new Insets(0, 0, 0, textWidthAndGap + iconWidth);
    }

    @Override
    public void paintSortableTableHeaderColumn(JComponent c, Graphics g2, Rectangle rect, int orientation, int state, int sortOrder, Icon sortIcon, int orderIndex, Color indexColor, boolean paintIndex) {
        int iconHeight = sortIcon == null ? 0 : sortIcon.getIconHeight();
        int iconWidth = sortIcon == null ? 0 : sortIcon.getIconWidth();
        int yOffset = sortIcon == null ? 0 : (rect.height - iconHeight) / 2 - V_GAP;
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        if (paintIndex && orderIndex != -1) {
            Font oldFont = g2.getFont();
            Font font = g2.getFont().deriveFont(0, oldFont.getSize() - 3);
            String str = "" + (orderIndex + 1);
            int textWidth = SwingUtilities.computeStringWidth(c.getFontMetrics(font), str);
            g2.setFont(font);
            Color oldColor = g2.getColor();
            g2.setColor(indexColor);
            int x = rect.x + rect.width / 2 - (iconWidth + ARROW_TEXT_GAP + textWidth) / 2;
            int y = rect.y + V_GAP;
            if (this.shouldDisplayOnTop()) {
                JideSwingUtilities.drawString(c, g2, str, x + ARROW_TEXT_GAP + iconWidth, rect.y + V_GAP + c.getFontMetrics(font).getAscent() - 2);
            } else if (leftToRight) {
                JideSwingUtilities.drawString(c, g2, str, rect.x + rect.width - textWidth - H_GAP, rect.y + yOffset + iconHeight / 2 + 1);
            } else {
                JideSwingUtilities.drawString(c, g2, str, rect.x + H_GAP, rect.y + yOffset + iconHeight / 2 + 1);
            }
            g2.setColor(oldColor);
            g2.setFont(oldFont);
            if (sortIcon != null) {
                if (!this.shouldDisplayOnTop()) {
                    x = leftToRight ? rect.x + rect.width - iconWidth - textWidth - H_GAP - ARROW_TEXT_GAP : rect.x + textWidth + H_GAP + ARROW_TEXT_GAP;
                }
                if (JdkSpecificClass.isSynthIcon(sortIcon)) {
                    JdkSpecificClass.paintTableHeaderIcon(c, sortIcon, g2, x, y);
                } else {
                    sortIcon.paintIcon(c, g2, x, y);
                }
            }
        } else if (sortIcon != null) {
            int x = rect.x + rect.width / 2 - iconWidth / 2;
            int y = rect.y + V_GAP;
            if (!this.shouldDisplayOnTop()) {
                if (leftToRight) {
                    x = rect.x + rect.width - iconWidth - H_GAP;
                    y = rect.y + yOffset;
                } else {
                    x = rect.x + H_GAP;
                    y = rect.y + yOffset;
                }
            }
            if (JdkSpecificClass.isSynthIcon(sortIcon)) {
                JdkSpecificClass.paintTableHeaderIcon(c, sortIcon, g2, x, y);
            } else {
                sortIcon.paintIcon(c, g2, x, y);
            }
        }
    }

    static {
        V_GAP = 0;
        H_GAP = 5;
        ARROW_TEXT_GAP = 0;
    }
}

