/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class KeycloakSessionUtil {
    private static final String NO_REALM = "no_realm_found_in_session";

    private KeycloakSessionUtil() {
    }

    public static KeycloakSession getKeycloakSession() {
        return (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
    }

    public static KeycloakSession setKeycloakSession(KeycloakSession session) {
        return (KeycloakSession)Resteasy.pushContext(KeycloakSession.class, (Object)session);
    }

    public static String getRealmNameFromContext(KeycloakSession session) {
        if (session == null) {
            return NO_REALM;
        }
        KeycloakContext context = session.getContext();
        if (context == null) {
            return NO_REALM;
        }
        RealmModel realm = context.getRealm();
        if (realm == null) {
            return NO_REALM;
        }
        if (realm.getName() != null) {
            return realm.getName();
        }
        return NO_REALM;
    }
}

