#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-EigmYGgEaKS4x2fL3obLK4
key:                  hledger-web-1.40-EigmYGgEaKS4x2fL3obLK4
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  bc02715f344e547c675bbfedb9bd5baf
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-EigmYGgEaKS4x2fL3obLK4
depends:
    Decimal-0.5.2-1TLmFAppZWOA8ldRyzVUiC
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf base-4.17.2.1
    base64-0.4.2.4-EaUmSnPsExZEDCCJXEoHh
    blaze-html-0.9.2.0-4nZEIuSQm5uJHuPTchkOVN
    blaze-markup-0.8.3.0-1slEV1JTVXCHBVRvUtps3k bytestring-0.11.5.3
    case-insensitive-1.2.1.0-A6Av13j1PriHVZgHNthY8h
    clientsession-0.9.3.0-BaH1MrfXDat1BIuYDexeUq
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-6jCM8OP1Acj1IIa26Jdl9d
    conduit-extra-1.3.8-gag7UpqEjaD10zdAjgLEE containers-0.6.7
    data-default-0.7.1.2-LONLsSvT4G81IL8ks6Ql72 directory-1.3.7.1
    extra-1.7.16-BWp1326BLeAsZES8r4M0Z filepath-1.4.2.2
    githash-0.1.6.3-DuEQZ1wDWbBmQ2lWDjigZ
    hjsmin-0.2.1-CIClgV76UeS6Nl0CvJ13L9
    hledger-1.40-660p0VXCGQG7AGTwodfkUj
    hledger-lib-1.40-CJwIOLXwokrAKs0CQbDCJk
    hspec-2.11.0.1-b9ATxP8AcYKxdBXowMjmM
    http-client-0.7.19-C1MyFeZ6J0U64oNAVz8qWH
    http-conduit-2.3.9.1-CHv81o5pwtXBQf5qQhZ9fb
    http-types-0.12.4-75PPyaYnKWt41SOfuGm1SN
    megaparsec-9.7.0-6xkhHCmKEAZB1EmG1WiH2F mtl-2.2.2
    network-3.1.4.0-18zdZgmnDKE1J4Hp557YCB
    safe-0.3.21-8UNW4gIoNRmKgGFufdPOla
    shakespeare-2.1.4-KYufEFOhEZ29XpQJ221co3 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-KxuMsRfldAv3o1PX9QN6ga
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-4DSUxPBVo3aDU1FL8Kb4AX
    wai-cors-0.2.7-As8l6LEF1Z2DgVODnBCRlD
    wai-extra-3.1.17-7sOIMyXdW19GMJAKYRA1MK
    wai-handler-launch-3.0.3.1-Ha3C7MyKsvW1JeFGohAXPl
    warp-3.3.30-L8efBONiiYN1bELlbKsQBo
    yaml-0.11.11.2-2rPjyCaPXyz9XPAN7vzk92
    yesod-1.6.2.1-HaT4amAjVy5E26bG2lFWXu
    yesod-core-1.6.27.1-3ogeKVIuSfX5uqaRYWvFRe
    yesod-form-1.7.9-9jn6f7IWJRrDuAwsrkUr8L
    yesod-static-1.6.1.0-831S2x4AVNf7P0joJVU3su
    yesod-test-1.6.23-L7TEHBFPeSxGJrcsO8sWK5

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

