#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.21
visibility:           public
id:                   hledger-iadd-1.3.21-BlhyoP6GgiYDE4YRv9N0Cr
key:                  hledger-iadd-1.3.21-BlhyoP6GgiYDE4YRv9N0Cr
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  c711f566dfeeae39480c27a03a7bc842
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.21
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.21
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.21-BlhyoP6GgiYDE4YRv9N0Cr
depends:
    base-4.17.2.1 brick-2.2-1KVDaH8QWh7JfvCnHIFONM containers-0.6.7
    directory-1.3.7.1 free-5.2-ERbQ4KpKIFl9MlA7wUwsjS
    hledger-lib-1.40-CJwIOLXwokrAKs0CQbDCJk
    megaparsec-9.7.0-6xkhHCmKEAZB1EmG1WiH2F
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    optparse-applicative-0.18.1.0-ImNwmQfwdUdQZElVvxe6u text-2.0.2
    text-zipper-0.13-G0nlWu7tX7PKjYVJs9rxqi time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    vector-0.13.2.0-B5pfN7kp2sVHpMWItbJQ58
    vty-6.2-3JAQfV88tluAzVgT4ckUaK
    xdg-basedir-0.2.2-GUgbFy73ZJ02w1NqlBIm8a

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

