#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
key:                  aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  87368ff3edc4be0dc2f7207b5215cf54
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
depends:
    OneTuple-0.4.2-C1A59Rl4Nec5GREMjr4xsX
    QuickCheck-2.14.3-9HL6RJfCtmHAzoR71QI1Po
    attoparsec-0.14.4-GTfBnxih117FV8L70A8efO base-4.17.2.1
    base-compat-batteries-0.13.0-EMcKp84h58O5d7WFFtf00k
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-Ic4RpFALHgTFxDi2KFv1Xo deepseq-1.4.8.0
    dlist-1.0-BKgPi70fx5AJreCYiKxIIN exceptions-0.10.5
    generically-0.1.1-AbyOksX16CCKeBRyhxTHJD ghc-prim-0.9.1
    hashable-1.4.4.0-ER9qsIVdqB66mmnPytAzi1
    indexed-traversable-0.1.4-GiogE6maAB3IzBkFbVsEUi
    primitive-0.9.1.0-49xiE5QgfWiA4gs3utiGrq
    scientific-0.3.8.0-DLDr5nembSsHeUMWxBP2Rn
    semialign-1.3.1-6Vy1Ck4CnN5Gzu0c17EQBL
    strict-0.5-G6b3Lbp4fx88QXx8VY6ukw
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-KE0J1f4kG7KEBU51g1mFmf
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-DdGDRUwWLRYJFt62iiTmEL time-1.12.2
    time-compat-1.9.7-20VXbOpHXdv2MVmC78BWzS
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    uuid-types-1.0.6-KK7UkzwimLWAwrEvPtiUBA
    vector-0.13.2.0-B5pfN7kp2sVHpMWItbJQ58
    witherable-0.4.2-I6KI7FiZekWJzC9hIzl5Fe

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

