/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.font;

import io.sf.carte.echosvg.gvt.font.GVTFont;
import io.sf.carte.echosvg.gvt.font.GVTGlyphMetrics;
import io.sf.carte.echosvg.gvt.font.GVTGlyphVector;
import io.sf.carte.echosvg.gvt.text.AttributedCharacterSpanIterator;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.List;

public class MultiGlyphVector
implements GVTGlyphVector {
    GVTGlyphVector[] gvs;
    int[] nGlyphs;
    int[] off;
    int nGlyph;

    public MultiGlyphVector(List<GVTGlyphVector> list) {
        int n = list.size();
        this.gvs = new GVTGlyphVector[n];
        this.nGlyphs = new int[n];
        this.off = new int[n];
        int n2 = 0;
        for (GVTGlyphVector gVTGlyphVector : list) {
            this.off[n2] = this.nGlyph;
            this.gvs[n2] = gVTGlyphVector;
            this.nGlyphs[n2] = gVTGlyphVector.getNumGlyphs();
            this.nGlyph += this.nGlyphs[n2];
            ++n2;
        }
        int n3 = n2 - 1;
        this.nGlyphs[n3] = this.nGlyphs[n3] + 1;
    }

    @Override
    public int getNumGlyphs() {
        return this.nGlyph;
    }

    int getGVIdx(int n) {
        if (n > this.nGlyph) {
            return -1;
        }
        if (n == this.nGlyph) {
            return this.gvs.length - 1;
        }
        for (int i = 0; i < this.nGlyphs.length; ++i) {
            if (n - this.off[i] >= this.nGlyphs[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public GVTFont getFont() {
        throw new IllegalArgumentException("Can't be correctly Implemented");
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.gvs[0].getFontRenderContext();
    }

    @Override
    public int getGlyphCode(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphCode(n - this.off[n2]);
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphJustificationInfo(n - this.off[n2]);
    }

    @Override
    public Shape getGlyphLogicalBounds(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphLogicalBounds(n - this.off[n2]);
    }

    @Override
    public GVTGlyphMetrics getGlyphMetrics(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphMetrics(n - this.off[n2]);
    }

    @Override
    public Shape getGlyphOutline(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphOutline(n - this.off[n2]);
    }

    @Override
    public Rectangle2D getGlyphCellBounds(int n) {
        return this.getGlyphLogicalBounds(n).getBounds2D();
    }

    @Override
    public Point2D getGlyphPosition(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphPosition(n - this.off[n2]);
    }

    @Override
    public AffineTransform getGlyphTransform(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphTransform(n - this.off[n2]);
    }

    @Override
    public Shape getGlyphVisualBounds(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphVisualBounds(n - this.off[n2]);
    }

    @Override
    public void setGlyphPosition(int n, Point2D point2D) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphPosition(n - this.off[n2], point2D);
    }

    @Override
    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphTransform(n - this.off[n2], affineTransform);
    }

    @Override
    public void setGlyphVisible(int n, boolean bl) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphVisible(n - this.off[n2], bl);
    }

    @Override
    public boolean isGlyphVisible(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].isGlyphVisible(n - this.off[n2]);
    }

    @Override
    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int[] nArray3 = null;
        int n3 = this.getGVIdx(n);
        int n4 = n - this.off[n3];
        int n5 = 0;
        while (n2 != 0) {
            int n6 = n2;
            if (n4 + n6 > this.nGlyphs[n3]) {
                n6 = this.nGlyphs[n3] - n4;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n3];
            if (n5 == 0) {
                gVTGlyphVector.getGlyphCodes(n4, n6, nArray2);
            } else {
                if (nArray3 == null || nArray3.length < n6) {
                    nArray3 = new int[n6];
                }
                gVTGlyphVector.getGlyphCodes(n4, n6, nArray3);
                System.arraycopy(nArray3, 0, nArray2, n5, n6);
            }
            n4 = 0;
            ++n3;
            n2 -= n6;
            n5 += n6;
        }
        return nArray2;
    }

    @Override
    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        float[] fArray3 = null;
        int n3 = this.getGVIdx(n);
        int n4 = n - this.off[n3];
        int n5 = 0;
        while (n2 != 0) {
            int n6 = n2;
            if (n4 + n6 > this.nGlyphs[n3]) {
                n6 = this.nGlyphs[n3] - n4;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n3];
            if (n5 == 0) {
                gVTGlyphVector.getGlyphPositions(n4, n6, fArray2);
            } else {
                if (fArray3 == null || fArray3.length < n6 * 2) {
                    fArray3 = new float[n6 * 2];
                }
                gVTGlyphVector.getGlyphPositions(n4, n6, fArray3);
                System.arraycopy(fArray3, 0, fArray2, n5, n6 * 2);
            }
            n4 = 0;
            ++n3;
            n2 -= n6;
            n5 += n6 * 2;
        }
        return fArray2;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        Rectangle2D rectangle2D = null;
        for (GVTGlyphVector gVTGlyphVector : this.gvs) {
            Rectangle2D rectangle2D2 = gVTGlyphVector.getLogicalBounds();
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public Shape getOutline() {
        Path2D path2D = null;
        for (GVTGlyphVector gVTGlyphVector : this.gvs) {
            Shape shape = gVTGlyphVector.getOutline();
            if (path2D == null) {
                path2D = new GeneralPath(shape);
                continue;
            }
            path2D.append(shape, false);
        }
        return path2D;
    }

    @Override
    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    @Override
    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        Rectangle2D rectangle2D = null;
        int n = attributedCharacterIterator.getBeginIndex();
        for (GVTGlyphVector gVTGlyphVector : this.gvs) {
            int n2 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            Rectangle2D rectangle2D2 = gVTGlyphVector.getBounds2D(new AttributedCharacterSpanIterator(attributedCharacterIterator, n, n2));
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
            } else {
                rectangle2D.add(rectangle2D2);
            }
            n = n2;
        }
        return rectangle2D;
    }

    @Override
    public Rectangle2D getGeometricBounds() {
        Rectangle2D rectangle2D = null;
        for (GVTGlyphVector gVTGlyphVector : this.gvs) {
            Rectangle2D rectangle2D2 = gVTGlyphVector.getGeometricBounds();
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public void performDefaultLayout() {
        for (GVTGlyphVector gVTGlyphVector : this.gvs) {
            gVTGlyphVector.performDefaultLayout();
        }
    }

    @Override
    public int getCharacterCount(int n, int n2) {
        int n3 = this.getGVIdx(n);
        int n4 = this.getGVIdx(n2);
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            int n6 = n - this.off[i];
            int n7 = n2 - this.off[i];
            if (n7 >= this.nGlyphs[i]) {
                n7 = this.nGlyphs[i] - 1;
            }
            n5 += this.gvs[i].getCharacterCount(n6, n7);
            n += n7 - n6 + 1;
        }
        return n5;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public void maybeReverse(boolean bl) {
    }

    @Override
    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        int n = attributedCharacterIterator.getBeginIndex();
        for (GVTGlyphVector gVTGlyphVector : this.gvs) {
            int n2 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            gVTGlyphVector.draw(graphics2D, new AttributedCharacterSpanIterator(attributedCharacterIterator, n, n2));
            n = n2;
        }
    }
}

