/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLPlugin;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PluginManagerDialog
extends DialogShell
implements ListSelectionListener,
ActionListener {
    private final JComboBox dockLocation;
    private boolean ignoreChanges = false;
    private final JList pluginNames;
    private final String activateName = Util.getResourceString("activatePlugin");
    private final String deactivateName = Util.getResourceString("deactivatePlugin");
    private final JButton toggleActivationButton;
    private final JCheckBox toggleActivationCheckbox;

    public PluginManagerDialog(Frame parent, String title) {
        super((Window)parent, title);
        Container contentPane = super.getContentPane();
        this.okButton.setText(Util.getResourceString("close"));
        this.cancelButton.setVisible(false);
        GridBagConstraints c = new GridBagConstraints();
        JPanel pluginPanel = new JPanel(new BorderLayout());
        pluginPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("pluginPanelTitle")));
        SHTMLPanelImpl.pluginManager.plugins();
        this.pluginNames = new JList<Object>(SHTMLPanelImpl.pluginManager.getPluginNames());
        this.pluginNames.addListSelectionListener(this);
        this.pluginNames.setMinimumSize(new Dimension(250, 400));
        this.pluginNames.setPreferredSize(new Dimension(250, 400));
        pluginPanel.add((Component)new JScrollPane(this.pluginNames), "Center");
        JPanel actionPanel = new JPanel();
        this.toggleActivationButton = new JButton(this.activateName);
        this.toggleActivationButton.setEnabled(false);
        this.toggleActivationButton.addActionListener(this);
        actionPanel.add(this.toggleActivationButton);
        pluginPanel.add((Component)actionPanel, "South");
        GridBagLayout g = new GridBagLayout();
        JPanel pluginSettingsPanel = new JPanel(g);
        this.toggleActivationCheckbox = new JCheckBox("togglePluginActivationCheckbox");
        this.toggleActivationCheckbox.setEnabled(false);
        this.toggleActivationCheckbox.addActionListener(this);
        Util.addGridBagComponent(pluginSettingsPanel, this.toggleActivationCheckbox, g, c, 0, 0, 17);
        Util.addGridBagComponent(pluginSettingsPanel, new JLabel(Util.getResourceString("dockLocationLabel")), g, c, 0, 1, 13);
        String[] locations = new String[]{Util.getResourceString("pluginDockLocationNone"), Util.getResourceString("pluginDockLocationTop"), Util.getResourceString("pluginDockLocationRight"), Util.getResourceString("pluginDockLocationBottom"), Util.getResourceString("pluginDockLocationLeft")};
        this.dockLocation = new JComboBox<String>(locations);
        this.dockLocation.setEnabled(false);
        this.dockLocation.addActionListener(this);
        Util.addGridBagComponent(pluginSettingsPanel, this.dockLocation, g, c, 1, 1, 17);
        contentPane.add((Component)pluginPanel, "West");
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel centerWestPanel = new JPanel(new BorderLayout());
        centerWestPanel.add((Component)pluginSettingsPanel, "North");
        centerPanel.add((Component)centerWestPanel, "West");
        centerPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("pluginSettingsPanelTitle")));
        contentPane.add((Component)centerPanel, "Center");
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.ignoreChanges = true;
        if (this.pluginNames.getSelectedIndex() > -1) {
            SHTMLPlugin p = this.getSelectedPlugin();
            boolean active = p.isActive();
            this.updateActivationButtonText(active);
            this.toggleActivationButton.setEnabled(true);
            this.toggleActivationCheckbox.setEnabled(true);
            this.toggleActivationCheckbox.setSelected(active);
            this.dockLocation.setSelectedIndex(p.getDockLocation());
            this.dockLocation.setEnabled(true);
        } else {
            this.toggleActivationButton.setEnabled(false);
            this.toggleActivationCheckbox.setEnabled(false);
            this.dockLocation.setEnabled(false);
        }
        this.ignoreChanges = false;
    }

    private SHTMLPlugin getSelectedPlugin() {
        String name = (String)this.pluginNames.getSelectedValue();
        return SHTMLPanelImpl.pluginManager.pluginForName(name);
    }

    private void updateActivationButtonText(boolean active) {
        if (active) {
            this.toggleActivationButton.setText(this.deactivateName);
        } else {
            this.toggleActivationButton.setText(this.activateName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.pluginNames.getSelectedIndex() > -1 && !this.ignoreChanges) {
            this.ignoreChanges = true;
            SHTMLPlugin p = this.getSelectedPlugin();
            if (source.equals(this.toggleActivationButton)) {
                p.setStatus(!p.isActive());
            } else if (source.equals(this.toggleActivationCheckbox)) {
                p.setStatus(!p.isActive());
            } else if (source.equals(this.dockLocation)) {
                p.setDockLocation(this.dockLocation.getSelectedIndex());
            } else {
                super.actionPerformed(e);
            }
            boolean active = p.isActive();
            this.toggleActivationCheckbox.setSelected(active);
            this.updateActivationButtonText(active);
            this.ignoreChanges = false;
        } else {
            super.actionPerformed(e);
        }
    }
}

