/**
 * SECTION:dummy-backend
 * @short_description: A backend which allows <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link>s and <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>s to be programmatically created and manipulated, for the purposes of testing the core of libfolks itself.
 * 
 * <para>This backend is not meant to be enabled in production use. The methods on <link linkend="FolksDummyBackend"><type>FolksDummyBackend</type></link> (and other classes) for programmatically manipulating the backend&apos;s state are considered internal to libfolks and are not stable.</para><para>This backend maintains two sets of persona stores: the set of all persona stores, and the set of enabled persona stores (which must be a subset of the former). <link linkend="folks-dummy-backend-register-persona-stores"><function>folks_dummy_backend_register_persona_stores()</function></link> adds persona stores to the set of all stores. Optionally it also enables them, adding them to the set of enabled stores. The set of persona stores advertised by the backend as <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> is the set of enabled stores. libfolks may internally enable or disable stores using <link linkend="folks-backend-enable-persona-store"><function>folks_backend_enable_persona_store()</function></link>, <link linkend="folks-backend-disable-persona-store"><function>folks_backend_disable_persona_store()</function></link> and <link linkend="folks-backend-set-persona-stores"><function>folks_backend_set_persona_stores()</function></link>. The <code>register_</code> and <code>unregister_</code> prefixes are commonly used for backend methods.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FOLKS_DUMMY_TYPE_BACKEND:
 * 
 * The type for <link linkend="FolksDummyBackend"><type>FolksDummyBackend</type></link>.
 */
/**
 * folks_dummy_backend_register_persona_stores:
 * @self: the <link linkend="FolksDummyBackend"><type>FolksDummyBackend</type></link> instance
 * @stores: (in): &nbsp;.  <para>set of persona stores to register </para>
 * @enable_stores: (in): &nbsp;.  <para>whether to automatically enable the stores </para>
 * 
 * Register and enable some <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link>s.
 * 
 * <para>For each of the persona stores in <code>stores</code>, register it with this backend. If <code>enable_stores</code> is <code>true</code>, added stores will also be enabled, emitting <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> for each newly-enabled store. After all addition signals are emitted, a change notification for <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> will be emitted (but only if at least one addition signal is emitted).</para><para>Persona stores are identified by their <link linkend="FolksPersonaStore--id"><type>"id"</type></link>; if a store in <code>stores</code> has the same ID as a store previously registered through this method, the duplicate will be ignored (so <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> won&apos;t be emitted for that store).</para><para>Persona stores must be instances of <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link> or subclasses of it, allowing for different persona store implementations to be tested.</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_backend_unregister_persona_stores:
 * @self: the <link linkend="FolksDummyBackend"><type>FolksDummyBackend</type></link> instance
 * @stores: &nbsp;
 * 
 * Disable and unregister some <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link>s.
 * 
 * <para>For each of the persona stores in <code>stores</code>, disable it (if it was enabled) and unregister it from the backend so that it cannot be re-enabled using <link linkend="folks-backend-enable-persona-store"><function>folks_backend_enable_persona_store()</function></link> or <link linkend="folks-backend-set-persona-stores"><function>folks_backend_set_persona_stores()</function></link>.</para><para><link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> will be emitted for all persona stores in <code>stores</code> which were previously enabled. After all removal signals are emitted, a change notification for <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> will be emitted (but only if at least one removal signal is emitted).</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_dummy_backend_new:
 * 
 * 
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyBackend:
 * 
 * A backend which allows <link linkend="FolksDummyPersonaStore"><type>FolksDummyPersonaStore</type></link>s and <link linkend="FolksDummyPersona"><type>FolksDummyPersona</type></link>s to be programmatically created and manipulated, for the purposes of testing the core of libfolks itself.
 * 
 * <para>This backend is not meant to be enabled in production use. The methods on <link linkend="FolksDummyBackend"><type>FolksDummyBackend</type></link> (and other classes) for programmatically manipulating the backend&apos;s state are considered internal to libfolks and are not stable.</para><para>This backend maintains two sets of persona stores: the set of all persona stores, and the set of enabled persona stores (which must be a subset of the former). <link linkend="folks-dummy-backend-register-persona-stores"><function>folks_dummy_backend_register_persona_stores()</function></link> adds persona stores to the set of all stores. Optionally it also enables them, adding them to the set of enabled stores. The set of persona stores advertised by the backend as <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> is the set of enabled stores. libfolks may internally enable or disable stores using <link linkend="folks-backend-enable-persona-store"><function>folks_backend_enable_persona_store()</function></link>, <link linkend="folks-backend-disable-persona-store"><function>folks_backend_disable_persona_store()</function></link> and <link linkend="folks-backend-set-persona-stores"><function>folks_backend_set_persona_stores()</function></link>. The <code>register_</code> and <code>unregister_</code> prefixes are commonly used for backend methods.</para><para>The API in FolksDummy is unstable and may change wildly. It is designed mostly for use by libfolks unit tests.</para>
 *
 * Since: 0.9.7
 */
/**
 * FolksDummyBackendClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-DUMMY-TYPE-BACKEND:CAPS"><literal>FOLKS_DUMMY_TYPE_BACKEND</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
