/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.annotations.SerializedName;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class OpenAIProperties
implements OpenAIBaseProperties {
    @SecureProperty
    @SerializedName(value="gpt.token")
    @Nullable
    private String token;
    @SerializedName(value="gpt.model")
    @Nullable
    private String model;
    @SerializedName(value="gpt.contextWindowSize")
    @Nullable
    private Integer contextWindowSize;
    @SerializedName(value="gpt.model.temperature")
    private Double temperature;
    @SerializedName(value="gpt.log.query")
    private Boolean loggingEnabled;

    @Override
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    public String getModel() {
        if (this.model != null) {
            return OpenAIModels.getEffectiveModelName(this.model);
        }
        String modelName = DBWorkbench.getPlatform().getPreferenceStore().getString("gpt.model");
        return OpenAIModels.getEffectiveModelName(modelName);
    }

    @Override
    public double getTemperature() {
        if (this.temperature != null) {
            return this.temperature;
        }
        return DBWorkbench.getPlatform().getPreferenceStore().getDouble("gpt.model.temperature");
    }

    @Override
    public boolean isLoggingEnabled() {
        if (this.loggingEnabled != null) {
            return this.loggingEnabled;
        }
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("gpt.log.query");
    }

    @Override
    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault("gpt.token", this.token);
    }

    @Override
    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue("gpt.token", this.token);
        }
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    public void setModel(@Nullable String model) {
        this.model = model;
    }

    @Override
    @Nullable
    public Integer getContextWindowSize() {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        return OpenAIModels.getContextWindowSize(this.getModel());
    }

    public void setContextWindowSize(@Nullable Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }
}

