/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;

public final class OpenAIModels {
    private static final Pattern CHAT_MODEL_PATTERN = Pattern.compile("^(gpt(-\\w+)?|o\\d+)(-mini|-pro|-turbo)?$");
    public static final String DEFAULT_MODEL = "gpt-4o";
    public static final Map<String, AIModel> KNOWN_MODELS = Stream.of(new AIModel("o4-mini", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o3-pro", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o3", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o3-mini", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o1-pro", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o1", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o1-mini", 128000, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-4.1", 0x100000, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-4o", 128000, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-4o-mini", 128000, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-4-turbo", 128000, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-3.5-turbo", 16384, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-4", 8192, Set.of(AIModelFeature.CHAT)), new AIModel("gpt-4o-transcribe", 128000, Set.of(AIModelFeature.SPEECH_TO_TEXT)), new AIModel("gpt-4o-mini-transcribe", 128000, Set.of(AIModelFeature.SPEECH_TO_TEXT)), new AIModel("whisper-1", 30000, Set.of(AIModelFeature.SPEECH_TO_TEXT))).collect(Collectors.toMap(AIModel::name, Function.identity()));
    public static final Set<String> DEPRECATED_MODELS = Set.of("gpt-3.5-turbo-0301", "gpt-3.5-turbo-0613", "gpt-3.5-turbo-1106", "gpt-3.5-turbo-16k", "gpt-3.5-turbo-16k-0613", "gpt-3.5-turbo-16k-1106");

    private OpenAIModels() {
    }

    public static String getEffectiveModelName(@Nullable String modelName) {
        if (modelName == null || modelName.isEmpty()) {
            return DEFAULT_MODEL;
        }
        String lowerCaseModelName = modelName.toLowerCase(Locale.ROOT);
        if (KNOWN_MODELS.containsKey(lowerCaseModelName)) {
            return lowerCaseModelName;
        }
        if (DEPRECATED_MODELS.contains(lowerCaseModelName)) {
            return DEFAULT_MODEL;
        }
        return lowerCaseModelName;
    }

    @Nullable
    public static Integer getContextWindowSize(@Nullable String modelName) {
        if (modelName == null) {
            return null;
        }
        AIModel knownModel = KNOWN_MODELS.get(modelName.toLowerCase(Locale.ROOT));
        if (knownModel != null) {
            return knownModel.contextWindowSize();
        }
        return null;
    }

    public static Set<AIModelFeature> getModelFeatures(@NotNull String modelName) {
        AIModel knownModel = KNOWN_MODELS.get(modelName.toLowerCase(Locale.ROOT));
        if (knownModel != null) {
            return knownModel.features();
        }
        HashSet<AIModelFeature> features = new HashSet<AIModelFeature>();
        if (CHAT_MODEL_PATTERN.matcher(modelName).matches()) {
            features.add(AIModelFeature.CHAT);
        }
        return Set.of();
    }
}

