/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;

public final class CopilotModels {
    public static final Map<String, AIModel> KNOWN_MODELS = Stream.of(new AIModel("claude-3.5-sonnet", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("claude-3.7-sonnet", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("claude-3.7-sonnet-thought", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("claude-sonnet-4", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("gemini-2.5-pro", 1000000, Set.of(AIModelFeature.CHAT)), new AIModel("gemini-2.0-flash-001", 1000000, Set.of(AIModelFeature.CHAT))).collect(Collectors.toMap(AIModel::name, Function.identity()));

    private CopilotModels() {
    }

    @Nullable
    public static Integer getContextWindowSize(@Nullable String model) {
        if (model == null) {
            return null;
        }
        AIModel copilotModel = KNOWN_MODELS.get(model);
        if (copilotModel != null) {
            return copilotModel.contextWindowSize();
        }
        AIModel openaiModel = OpenAIModels.KNOWN_MODELS.get(model);
        if (openaiModel != null) {
            return openaiModel.contextWindowSize();
        }
        return null;
    }
}

