/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.preferences;

import java.io.IOException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.impl.AISchemaGeneratorImpl;
import org.jkiss.dbeaver.model.ai.registry.AISchemaGeneratorRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.format.DefaultFormattingConfigurator;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class AIPreferencePageConfiguration
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(AIPreferencePageConfiguration.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.ai.config";
    private final AISettings settings = AISettingsRegistry.getInstance().getSettings();
    private AISchemaGenerator ddlGenerator;
    private IObjectPropertyConfigurator<AISchemaGenerator, AISettings> formatterConfigurator;

    public AIPreferencePageConfiguration() {
        try {
            this.ddlGenerator = AISchemaGeneratorRegistry.getInstance().getDdlGenerator();
        }
        catch (DBException e) {
            log.error((Object)"Formatter not found", (Throwable)e);
            this.ddlGenerator = new AISchemaGeneratorImpl();
        }
        UIPropertyConfiguratorDescriptor cfgDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.ddlGenerator.getClass().getName());
        if (cfgDescriptor != null) {
            try {
                this.formatterConfigurator = cfgDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.formatterConfigurator == null) {
            this.formatterConfigurator = new DefaultFormattingConfigurator();
        }
    }

    public IAdaptable getElement() {
        return this.settings;
    }

    public void setElement(IAdaptable element) {
    }

    protected void performDefaults() {
        if (!this.hasAccessToPage()) {
            return;
        }
        this.formatterConfigurator.loadSettings((Object)this.settings);
    }

    public boolean performOk() {
        if (!this.hasAccessToPage()) {
            return false;
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.formatterConfigurator.saveSettings((Object)this.settings);
        AISettingsRegistry.getInstance().saveSettings(this.settings);
        try {
            store.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        this.formatterConfigurator.createControl(composite, (Object)this.ddlGenerator, () -> {});
        Composite serviceComposite = UIUtils.createComposite((Composite)composite, (int)2);
        serviceComposite.setLayoutData((Object)new GridData(32));
        this.performDefaults();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected boolean hasAccessToPage() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
    }
}

