// Generated by gmmproc 2.85.0 -- DO NOT MODIFY!
#ifndef _GTKMM_PRINTSETUP_H
#define _GTKMM_PRINTSETUP_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/refptr.h>
#include <gtkmm/pagesetup.h>
#include <gtkmm/printsettings.h>


namespace Gtk
{

/** An auxiliary object for printing that allows decoupling the setup from the printing.
 *
 * A print setup is obtained by calling Gtk::PrintDialog::setup_finish(),
 * and can later be passed to print functions such as Gtk::PrintDialog::print().
 *
 * Print setups can be reused for multiple print calls.
 *
 * Applications may wish to store the page_setup and print_settings from the
 * print setup and copy them to the PrintDialog if they want to keep using them.
 *
 * @ingroup Printing
 * @newin{4,14}
 */
class GTKMM_API PrintSetup final
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = PrintSetup;
  using BaseObjectType = GtkPrintSetup;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GtkPrintSetup*       gobj();

  ///Provides access to the underlying C instance.
  const GtkPrintSetup* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPrintSetup* gobj_copy() const;

  PrintSetup() = delete;

  // noncopyable
  PrintSetup(const PrintSetup&) = delete;
  PrintSetup& operator=(const PrintSetup&) = delete;

protected:
  // Do not derive this.  Gtk::PrintSetup can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
  
  /** Returns the print settings of @a setup.
   * 
   * They may be different from the `Gtk::PrintDialog`'s settings
   * if the user changed them during the setup process.
   * 
   * @newin{4,14}
   * 
   * @return The print settings, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<PrintSettings> get_print_settings();
  
  /** Returns the print settings of @a setup.
   * 
   * They may be different from the `Gtk::PrintDialog`'s settings
   * if the user changed them during the setup process.
   * 
   * @newin{4,14}
   * 
   * @return The print settings, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const PrintSettings> get_print_settings() const;
  
  /** Returns the page setup of @a setup.
   * 
   * It may be different from the `Gtk::PrintDialog`'s page setup
   * if the user changed it during the setup process.
   * 
   * @newin{4,14}
   * 
   * @return The page setup, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<PageSetup> get_page_setup();
  
  /** Returns the page setup of @a setup.
   * 
   * It may be different from the `Gtk::PrintDialog`'s page setup
   * if the user changed it during the setup process.
   * 
   * @newin{4,14}
   * 
   * @return The page setup, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const PageSetup> get_page_setup() const;


};

} // namespace Gtk


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gtk::PrintSetup
 */
GTKMM_API
Glib::RefPtr<Gtk::PrintSetup> wrap(GtkPrintSetup* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_PRINTSETUP_H */

