/*
 * Distributed under the OSI-approved Apache License, Version 2.0.  See
 * accompanying file Copyright.txt for details.
 *
 * adios2.h : single unique header for applications using ADIOS2 C++11 bindings
 *
 *  Created on: Jun 4, 2018
 *      Author: William F Godoy godoywf@ornl.gov
 */

#ifndef ADIOS2_BINDINGS_CXX11_H_
#define ADIOS2_BINDINGS_CXX11_H_

#include "adios2/common/ADIOSConfig.h"
#include "adios2/common/ADIOSMacros.h"
#include "adios2/common/ADIOSTypes.h"

#include "adios2/cxx11/ADIOS.h"
#include "adios2/cxx11/Attribute.h"
#include "adios2/cxx11/Engine.h"
#include "adios2/cxx11/Group.h"
#include "adios2/cxx11/IO.h"
#include "adios2/cxx11/Operator.h"
#include "adios2/cxx11/Query.h"
#include "adios2/cxx11/Types.h"
#include "adios2/cxx11/Variable.h"
#include "adios2/cxx11/fstream/ADIOS2fstream.h"

#endif /* ADIOS2_BINDINGS_CXX11_H_ */
